import enum

from matrx.agents.agent_utils.navigator import Navigator, AStarPlanner
from matrx.agents.agent_utils.state_tracker import StateTracker
from matrx.agents import AgentBrain
from matrx.messages import Message
from moving_out.actions.custom_actions import CarryObject, LowerObject, dropzone, safezone
from matrx.actions.object_actions import GrabObject, DropObject
from matrx.objects import EnvObject
import time

safeloc = [12,5]
faulty_build_boxes = [
    {"location": (2,3), "weight": "light", "owner": "human"},
    {"location": (17,5), "weight": "heavy", "owner": "human"},
    {"location": (4,9), "weight": "light", "owner": "robot"}
    ]


class Todo(enum.Enum):
    # add todos
    FIND_NEXT_BOX = 0,
    GO_TO_BOX = 1,
    CARRY_BOX = 2,
    GO_TO_DROPZONE = 3,
    GO_TO_SAFEZONE = 4,
    WAIT_AT_BOX = 5,
    LOWER_BOX = 6,
    GO_TO_HUMAN = 7,
    WAIT_FOR_DROP = 8,
    WAIT_FOR_HUMAN = 9,
    STOP_WAITING = 10


class FaultyAgent(AgentBrain):
    """ An artificial agent whose behaviour can be programmed to be, for example, (semi-)autonomous.

    For more extensive documentation on the functions below, see:
    http://docs.matrx-software.com/en/master/sections/_generated_autodoc/matrx.agents.agent_brain.AgentBrain.html#matrx.agents.agent_brain.AgentBrain
    """

    def __init__(self, max_carry_objects=1,
                 grab_range=0, **kwargs):
        """ Creates an agent brain to move along a set of waypoints.
        """
        super().__init__(**kwargs)
        self.waypoints = [] if 'waypoints' not in kwargs else kwargs['waypoints']
        self.__max_carry_objects = max_carry_objects
        self.__grab_range = grab_range
        self.todo = Todo.FIND_NEXT_BOX
        self.box = None
        self.next_todo = None
        self.carrying_same_box = False
        self.humanloc = None

    def initialize(self):
        # initialize state tracker
        self.state_tracker = StateTracker(agent_id=self.agent_id)
        self.navigator = Navigator(agent_id=self.agent_id, action_set=self.action_set,
                                   algorithm=Navigator.A_STAR_ALGORITHM)
        self.navigator.add_waypoints(self.waypoints, is_circular=False)

    def filter_observations(self, state):
        """ Filters the world state before deciding on an action. """
        return state

    def decide_on_action(self, state):
        """ Contains the decision logic of the agent. """
        action = None
        action_kwargs = {"action_duration": 20}
        # Set grab range
        action_kwargs['grab_range'] = self.__grab_range
        # Set max amount of objects
        action_kwargs['max_objects'] = self.__max_carry_objects

        while True:
            # get human
            human = state.get_agents_with_property({"name": "human"})[0]
            # get robot
            robot = state.get_agents_with_property({"name": "robot"})[0]
            if self.todo == Todo.STOP_WAITING:
                self.agent_properties["img_name"] = "robot.png"
                self.todo = Todo.FIND_NEXT_BOX
            for message in list(self.received_messages):
                if message.content == 'HELP-HEAVY':
                    self.humanloc = human.get('location')  # to get the location where the human was at that moment
                    # is robot carrying a box?
                    if robot['is_carrying']:
                        # let the robot do its thing
                        # set next todo to go to human
                        self.next_todo = Todo.GO_TO_HUMAN
                    else:
                        self.todo = Todo.GO_TO_HUMAN
                elif message.content == 'LOWER-BOX':
                    # if todo is to wait for a drop, set todo to lowering the box
                    if self.todo == Todo.WAIT_FOR_DROP:
                        self.todo = Todo.LOWER_BOX
                    elif self.carrying_same_box:
                        # get all objects in the world
                        objects = state.get_objects_in_area((0, 0), world_width, world_height,
                                                            (world_width, world_height))
                        # find next up box
                        ghostboxes = [x for x in objects if x['name'] == 'ghostbox']
                        # get the properties of the next box to be found
                        props = ghostboxes[0]
                        self.box['destination'] = props['location']
                        self.todo = Todo.GO_TO_DROPZONE
                    elif self.todo == Todo.WAIT_FOR_HUMAN:
                        self.todo = Todo.STOP_WAITING
                    self.carrying_same_box = False
                elif message.content == 'CARRYING':
                    # get human
                    human = state.get_agents_with_property({"name": "human"})[0]
                    # get robot
                    robot = state.get_agents_with_property({"name": "robot"})[0]
                    # is robot carrying the same box as the human?
                    robot_carries = robot['is_carrying'][0] if robot['is_carrying'] else None
                    human_carries = human['is_carrying'][0] if human['is_carrying'] else None
                    if human_carries:
                        # if the robot is invisible because they are carrying together
                        if robot['visualization']['opacity'] == 0:
                            self.todo = Todo.WAIT_FOR_DROP
                        elif robot_carries and robot_carries['weight'] == human_carries['weight'] and robot_carries['owner'] == human_carries['owner']:
                            self.carrying_same_box = True
                            # is the box after the next up the same type of box?
                            # get all objects in the world
                            objects = state.get_objects_in_area((0, 0), world_width, world_height,
                                                                (world_width, world_height))
                            # get only ghost boxes
                            ghostboxes = [x for x in objects if x['name'] == 'ghostbox']
                            if len(ghostboxes) >=2:
                                # get the properties of the next box to be found
                                props = ghostboxes[0]
                                next_props = ghostboxes[1]
                                if props['weight'] == next_props['weight'] and props['owner'] == next_props['owner']:
                                    # then set todo to go to dropzone
                                    self.todo = Todo.GO_TO_DROPZONE
                                # if not, set todo to go to safezone
                                else:
                                    self.todo = Todo.GO_TO_SAFEZONE
                        # is the robot not carrying anything?
                        elif not robot_carries:
                            # set todo to find next box
                            self.todo = Todo.FIND_NEXT_BOX
                self.received_messages.remove(message)
            if self.todo == Todo.WAIT_FOR_HUMAN:
                self.agent_properties["img_name"] = "robot_help.png"
            if self.todo == Todo.FIND_NEXT_BOX:
                # get human
                human = state.get_agents_with_property({"name": "human"})[0]
                # get robot
                robot = state.get_agents_with_property({"name": "robot"})[0]
                # get all objects in the world
                objects = state.get_objects_in_area((0, 0), world_width, world_height, (world_width, world_height))
                # remove all non-boxes (because for some reason it also gets a room and a room does not have an image)
                boxes = [x for x in objects if x['name'] == 'box']
                props = None
                if boxes:
                    # find next up box
                    ghostboxes = [x for x in objects if x['name'] == 'ghostbox']
                    if ghostboxes:
                        # get the properties of the next box to be found
                        props = ghostboxes[0]
                        # check what human carries
                        human_carries = human['is_carrying'][0] if human['is_carrying'] else None
                        # is human carrying the next up box?
                        if human_carries and human_carries['weight'] == props['weight'] and human_carries['owner'] == props['owner']:
                            # find box props after that
                            if len(ghostboxes) >= 2:
                                props = ghostboxes[1]
                                # if robot is not already at the box in safezone location
                                if robot['location'] == tuple(safeloc):
                                    self.todo = Todo.FIND_NEXT_BOX
                                else:
                                    # set todo to going to box
                                    self.todo = Todo.GO_TO_BOX
                                    # set next todo to go to safepoint
                                    self.next_todo = Todo.GO_TO_SAFEZONE
                        # is human not carrying next up box?
                        else:
                            # set todo to going to box
                            self.todo = Todo.GO_TO_BOX
                        # find the box with those props
                        if props:
                            obj = state.get_closest_with_property(
                                props={'weight': props['weight'], 'owner': props['owner'], 'is_movable': True})
                            if obj:
                                obj[0]['destination'] = props['location']
                                self.box = obj[0]
            if self.todo == Todo.GO_TO_BOX:
                self.navigator.reset_full()  # for some reasons it's looping if we don't reset the waypoints
                self.navigator.add_waypoint(tuple(self.box["location"]))
                self.state_tracker.update(state)
                action = self.navigator.get_move_action(self.state_tracker)
                if action != None:
                    return action, action_kwargs
                # set todo to carry box when finished walking
                self.todo = Todo.CARRY_BOX
            if self.todo == Todo.CARRY_BOX:
                robot = state.get_agents_with_property({"name": "robot"})[0]
                human = state.get_agents_with_property({"name": "human"})[0]
                # give id of box
                action_kwargs['object_id'] = self.box['obj_id']
                # if box is heavy, check if human is nearby
                if self.box['weight'] == 'heavy':
                    # if nearby, carry box together
                    if robot['location'] == human['location']:
                        # set no waypoint cause human will decide direction
                        # set todo to wait for drop
                        self.todo = Todo.WAIT_FOR_DROP
                        self.next_todo = None
                        return CarryObject.__name__, action_kwargs
                    # if not set todo to wait for human
                    else:
                        self.todo = Todo.WAIT_FOR_HUMAN
                        return CarryObject.__name__, action_kwargs
                # if box is light, pick up box
                else:
                    # if next todo is go to safepoint, set todo to safepoint
                    # otherwise set todo to go to destination of box
                    self.todo = self.next_todo if self.next_todo else Todo.GO_TO_DROPZONE
                    self.next_todo = None
                    return CarryObject.__name__, action_kwargs
            if self.todo == Todo.GO_TO_DROPZONE:
                # get human
                human = state.get_agents_with_property({"name": "human"})[0]
                # get robot
                robot = state.get_agents_with_property({"name": "robot"})[0]
                # check if robot is carrying the same box as the human, to keep checking when the human drops it
                robot_carries = robot['is_carrying'][0] if robot['is_carrying'] else None
                human_carries = human['is_carrying'][0] if human['is_carrying'] else None
                if robot_carries and human_carries and robot_carries['weight'] == human_carries[
                    'weight'] and robot_carries['owner'] == human_carries['owner']:
                    self.carrying_same_box = True
                # check whether the ghostboxes haven't changed (because of a broken box, for example)
                # get all objects in the world
                objects = state.get_objects_in_area((0, 0), world_width, world_height,
                                                    (world_width, world_height))
                # find next up box
                ghostboxes = [x for x in objects if x['name'] == 'ghostbox']
                # get the properties of the next box to be found
                props = ghostboxes[0]
                if robot_carries['weight']==props['weight'] and robot_carries['owner'] == props['owner']:
                    self.box['destination'] = props['location']
                    # set waypoints to dropzone loc
                    self.navigator.reset_full()
                    self.navigator.add_waypoint(self.box['destination'])
                    self.state_tracker.update(state)
                    action = self.navigator.get_move_action(self.state_tracker)
                    if action != None:
                        return action, action_kwargs
                    # when finished walking, set todo to lower box
                    self.todo = Todo.LOWER_BOX
                # otherwise, drop it at safezone
                else:
                    self.todo = Todo.GO_TO_SAFEZONE
            if self.todo == Todo.GO_TO_SAFEZONE:
                # get human
                human = state.get_agents_with_property({"name": "human"})[0]
                # get robot
                robot = state.get_agents_with_property({"name": "robot"})[0]
                # check whether the ghostboxes haven't changed (because of a broken box, for example)
                robot_carries = robot['is_carrying'][0] if robot['is_carrying'] else None
                # get all objects in the world
                objects = state.get_objects_in_area((0, 0), world_width, world_height,
                                                    (world_width, world_height))
                # find next up box
                ghostboxes = [x for x in objects if x['name'] == 'ghostbox']
                # get the properties of the next box to be found
                props = ghostboxes[0]
                if robot_carries['weight'] == props['weight'] and robot_carries['owner'] == props['owner']:
                    self.box['destination'] = props['location']
                    self.todo = Todo.GO_TO_DROPZONE
                else:
                    # set waypoints to safezone loc
                    self.navigator.reset_full()
                    self.navigator.add_waypoint(tuple(safeloc)) # hardcoded safezone loc
                    self.state_tracker.update(state)
                    action = self.navigator.get_move_action(self.state_tracker)
                    if action != None:
                        return action, action_kwargs
                    # when finished walking, set todo to lower box
                    self.todo = Todo.LOWER_BOX
                    self.next_todo = Todo.FIND_NEXT_BOX
            if self.todo == Todo.LOWER_BOX:
                # give destination with the function
                action_kwargs['destination'] = self.box['destination']
                # set todo to find next box, if there is no next todo
                self.todo = self.next_todo if self.next_todo else Todo.FIND_NEXT_BOX
                self.next_todo = None
                self.carrying_same_box = False
                # lower the box it is carrying
                return LowerObject.__name__, action_kwargs
            if self.todo == Todo.GO_TO_HUMAN:
                self.agent_properties["img_name"] = "robot.png"
                if human.get('location') == self.humanloc:
                    # set waypoint to human location
                    self.navigator.reset_full()  # for some reasons it's looping if we don't reset the waypoints
                    self.navigator.add_waypoint(self.humanloc)
                    self.state_tracker.update(state)
                    action = self.navigator.get_move_action(self.state_tracker)
                    # wait until robot arrives
                    if action != None:
                        return action, action_kwargs
                    # when it arrives, check whether there is indeed a heavy box and the human is still there
                    closest_heavy_box = state.get_closest_with_property(props={"weight": "heavy", "location": human.get("location")})
                    self.box = closest_heavy_box[0] if closest_heavy_box else None
                    # get all objects in the world
                    objects = state.get_objects_in_area((0, 0), world_width, world_height,
                                                        (world_width, world_height))
                    # find next up box
                    ghostboxes = [x for x in objects if x['name'] == 'ghostbox']
                    heavy_ghostboxes = [x for x in ghostboxes if x['weight'] == 'heavy']
                    # get the properties of the next box to be found
                    props = heavy_ghostboxes[0]
                    # if so, set todo to carry the box
                    if self.box:
                        self.box['destination'] = props['location']
                        self.todo = Todo.CARRY_BOX
                    # if not, set todo to find the next box
                    else:
                        self.todo = Todo.FIND_NEXT_BOX
                else:
                    self.todo = Todo.FIND_NEXT_BOX
            return action, action_kwargs

    def _set_messages(self, messages=None):
        # make sure we save the entire message and not only the content
        for mssg in messages:
            received_message = mssg
            self.received_messages.append(received_message)